﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System
Imports System.Text
Imports System.Runtime.InteropServices
Imports System.IO

Public Class MainForm


    Const StringBufferLength As Integer = 255

#Region "API 调用"

    ''' <summary>
    ''' 这演示使用函数 Beep 的不同调用变体。检查
    ''' 类 CallingVariations 中的声明。
    ''' </summary>
    Private Sub btnBeep_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnBeep.Click
        If rbDeclare.Checked Then
            CallingVariations.DeclareBeep(1000, 1000)
        ElseIf rbDLLImport.Checked Then
            CallingVariations.DLLImportBeep(1000, 1000)
        ElseIf rbANSI.Checked Then
            CallingVariations.ANSIBeep(1000, 1000)
        ElseIf rbUnicode.Checked Then
            CallingVariations.UnicodeBeep(1000, 1000)
        ElseIf rbAuto.Checked Then
            CallingVariations.AutoBeep(1000, 1000)
        End If
    End Sub

    ''' <summary>
    ''' 这在可能时创建一个目录，并更新状态 txtFunctionOutput。
    ''' </summary>
    Private Sub btnCreateDirectory_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCreateDirectory.Click
        Dim security As New Win32API.SECURITY_ATTRIBUTES()

        ' 该函数在封送到非托管代码时需要知道结构大小。
        security.nLength = Marshal.SizeOf(security)
        security.lpSecurityDescriptor = 0
        security.bInheritHandle = 0

        If Win32API.CreateDirectory(txtDirectory.Text, security) Then
            txtFunctionOutput.Text = "Directory created."
        Else
            txtFunctionOutput.Text = "Directory not created."
        End If
    End Sub

    ''' <summary>
    ''' 这使用 Win32 API 调用 GetDiskFreeSpace 获取磁盘上可用簇的数目，
    ''' 并更新 txtFunctionOutput。
    ''' </summary>
    Private Sub btnGetFreeSpace_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetFreeSpace.Click
        Dim rootPathName As String
        Dim sectorsPerCluster As Integer
        Dim bytesPerSector As Integer
        Dim numberOfFreeClusters As Integer
        Dim totalNumberOfClusters As Integer


        rootPathName = txtDriveLetter.Text & ":" & Path.DirectorySeparatorChar

        Win32API.GetDiskFreeSpace(rootPathName, sectorsPerCluster, bytesPerSector, _
            numberOfFreeClusters, totalNumberOfClusters)

        txtFunctionOutput.Text = "Number of Free Clusters: " & _
            numberOfFreeClusters.ToString()
    End Sub

    ''' <summary>
    ''' 这使用 Win32 API 调用 GetDiskFreeSpaceEx 获取磁盘上可用字节的数目，
    ''' 并更新 txtFunctionOutput。
    ''' </summary>
    Private Sub btnGetDiskFreeSpaceEx_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetDiskFreeSpaceEx.Click
        Dim rootPathName As String
        Dim freeBytesToCaller As Integer
        Dim totalNumberOfBytes As Integer
        Dim totalNumberOfFreeBytes As UInt32

        rootPathName = txtDriveLetter.Text & ":" & Path.DirectorySeparatorChar

        Win32API.GetDiskFreeSpaceEx(rootPathName, freeBytesToCaller, totalNumberOfBytes, _
            totalNumberOfFreeBytes)

        txtFunctionOutput.Text = "Number of Free Bytes: " & _
            totalNumberOfFreeBytes.ToString()
    End Sub

    ''' <summary>
    ''' 这使用 Win32 API 调用 GetDriveType 显示驱动器类型，并更新 txtFunctionOutput
    ''' 文本框。
    ''' </summary>
    Private Sub btnGetDriveType_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetDriveType.Click
        Dim rootPathName As String
        rootPathName = txtDriveLetter.Text & ":" & Path.DirectorySeparatorChar

        Select Case Win32API.GetDriveType(rootPathName)
            Case 2
                txtFunctionOutput.Text = "Drive type: Removable"
            Case 3
                txtFunctionOutput.Text = "Drive type: Fixed"
            Case Is = 4
                txtFunctionOutput.Text = "Drive type: Remote"
            Case Is = 5
                txtFunctionOutput.Text = "Drive type: Cd-Rom"
            Case Is = 6
                txtFunctionOutput.Text = "Drive type: Ram disk"
            Case Else
                txtFunctionOutput.Text = "Drive type: Unrecognized"
        End Select
    End Sub

    ''' <summary>
    ''' 这获取操作系统版本并更新 txtFunctionOutput。
    ''' </summary>
    Private Sub btnGetOSVersion_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetOSVersion.Click
        Dim versionInfo As New Win32API.OSVersionInfo()

        ' 该函数在封送到非托管代码时需要知道结构大小。
        versionInfo.OSVersionInfoSize = Marshal.SizeOf(versionInfo)
        Win32API.GetVersionEx(versionInfo)

        txtFunctionOutput.Text = "Build Number is: " & versionInfo.buildNumber.ToString() & Chr(13) & Chr(10)
        txtFunctionOutput.Text += "Major Version Number is: " & versionInfo.majorVersion.ToString()
    End Sub

    ''' <summary>
    ''' 这在可能时挂起计算机。
    ''' </summary>
    Private Sub btnHibernate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnHibernate.Click
        If Win32API.IsPwrHibernateAllowed() <> 0 Then
            If MsgBox("Do you want to hibernate this computer?", MsgBoxStyle.YesNo, "Confirm Hibernation") = MsgBoxResult.Yes Then
                Win32API.SetSuspendState(1, 0, 0)
            End If
        Else
            txtFunctionOutput.Text = "Your computer does not support hibernation.  " & _
                "This may be due to system settings or simply a computer bios that does not support hibernation."
        End If
    End Sub

    ''' <summary>
    ''' 将鼠标按钮设置为默认设置。
    ''' </summary>
    Private Sub btnResetMouseButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnResetMouseButton.Click
        Win32API.SwapMouseButton(0)
    End Sub

    ''' <summary>
    ''' 交换鼠标按钮。
    ''' </summary>
    Private Sub btnSwapMouseButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSwapMouseButton.Click
        Win32API.SwapMouseButton(1)
    End Sub
#End Region

    ''' <summary>
    ''' 此子例程清除进程列表视图，并使用所有活动进程进行填充。
    ''' </summary>
    Private Sub btnRefreshActiveProcesses_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnRefreshActiveProcesses.Click
        lvwProcessList.Items.Clear()

        ' 调用 WinAPI 函数 EnumWindows，将 FillActiveProcessList 函数指定为
        ' 针对每个活动进程调用一次的函数。因为 EnumWindows 是
        ' 非托管代码，所以需要创建一个委托，从而允许其调用
        ' 托管代码 FillActiveProcessList。
        Win32API.EnumWindows(New Win32API.EnumWindowsCallback(AddressOf _
            FillActiveProcessList), 0)
    End Sub

    ''' <summary>
    ''' 此子例程清除活动窗口列表，并使用所有活动窗口进行填充。
    ''' </summary>
    Private Sub btnRefreshActiveWindows_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnRefreshActiveWindows.Click
        lbActiveWindows.Items.Clear()

        ' EnumWindowDllImport 的工作方式与 btnRefreshActiveProcesses_Click 中相同，
        ' 但它是使用 DllImport 而不是 Declare 定义的。
        Win32API.EnumWindowsDllImport(New Win32API.EnumWindowsCallback(AddressOf _
            FillActiveWindowsList), 0)
    End Sub

    ''' <summary>
    ''' 此子例程根据窗口标题和类名文本框中的值查找活动窗口，
    ''' 并将其置于前台。
    ''' </summary>
    Private Sub btnShow_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnShow.Click
        Dim hWnd As Integer

        ' Win32API 类中的 Win32API 函数 FindWindow 具有四个重载，
        ' 从而允许将 String 或 Integer 传递到类名和
        ' 窗口名称。如果两个字段中有一个为空，则将 0 传递给参数会
        ' 将 NULL 封送到函数调用。
        If txtWindowCaption.Text = "" And txtClassName.Text = "" Then
            ' FindWindowAny 采用 Integer 参数，并查找任何可用窗口。
            hWnd = Win32API.FindWindowAny(0, 0)
        ElseIf txtWindowCaption.Text = "" And txtClassName.Text <> "" Then
            ' FindWindowNullWindowCaption 尝试只根据类名定位窗口。
            hWnd = Win32API.FindWindowNullWindowCaption(txtClassName.Text, 0)
        ElseIf txtWindowCaption.Text <> "" And txtClassName.Text = "" Then
            ' FindWindowNullClassName 尝试只根据窗口名称定位窗口。 
            hWnd = Win32API.FindWindowNullClassName(0, txtWindowCaption.Text)
        Else
            ' FindWindow 根据类名和窗口名称搜索窗口。
            hWnd = Win32API.FindWindow(txtClassName.Text, txtWindowCaption.Text)
        End If

        ' 如果找不到窗口，则 FindWindow 将窗口句柄设置为 0。如果该
        ' 句柄为 0，则会显示错误信息，否则会将该窗口置于前台。
        If hWnd = 0 Then
            MsgBox("Specified window is not running.", MsgBoxStyle.Exclamation, Me.Text)
        Else
            ' 将窗口设置为前台窗口。
            Win32API.SetForegroundWindow(hWnd)

            ' 如果窗口是最小化的，则只需将其还原，否则应显示该窗口。注意，
            ' Win32API.IsIconic 的声明将返回值定义为 Boolean，
            ' 从而允许 .NET 将整数值封送到 Boolean。
            If Win32API.IsIconic(hWnd) Then
                Win32API.ShowWindow(hWnd, Win32API.SW_RESTORE)
            Else
                Win32API.ShowWindow(hWnd, Win32API.SW_SHOW)
            End If
        End If
    End Sub

    ''' <summary>
    ''' 此子例程检查窗口标题和类名文本框，
    ''' 并相应地更新 lblFunctionCalled 标签。
    ''' </summary>
    Private Sub ChangeFunctionCalledLabel()
        If txtWindowCaption.Text = "" And txtClassName.Text = "" Then
            lblFunctionCalled.Text = _
                "FindWindow (ClassName As Integer, WindowName As Integer) will be called."
        ElseIf txtWindowCaption.Text = "" And txtClassName.Text <> "" Then
            lblFunctionCalled.Text = _
                "FindWindow (ClassName As String, WindowName As Integer) will be called."
        ElseIf txtWindowCaption.Text <> "" And txtClassName.Text = "" Then
            lblFunctionCalled.Text = _
                "FindWindow (ClassName As Integer, WindowName As String) will be called."
        Else
            lblFunctionCalled.Text = _
                "FindWindow (ClassName As String, WindowName As String) will be called."
        End If
    End Sub

    ''' <summary>
    ''' 此函数由 EnumWindows 针对每个活动进程调用一次。
    ''' 它获取窗口标题和类名，并更新进程项列表视图。
    ''' </summary>
    Function FillActiveProcessList(ByVal hWnd As Integer, ByVal lParam As Integer) As Boolean
        Dim windowText As New StringBuilder(StringBufferLength)
        Dim className As New StringBuilder(StringBufferLength)

        ' 获取窗口标题和类名。注意，Win32API 类中
        ' Win32API 函数定义的声明方式与 VB6 中不同。所有 Long 均被替换为
        ' Integer，String 则替换为 StringBuilder。
        Win32API.GetWindowText(hWnd, windowText, StringBufferLength)
        Win32API.GetClassName(hWnd, className, StringBufferLength)

        ' 向进程列表视图中添加一个新的进程项。
        Dim processItem As New ListViewItem(windowText.ToString, 0)
        processItem.SubItems.Add(className.ToString)
        processItem.SubItems.Add(hWnd.ToString)
        lvwProcessList.Items.Add(processItem)
        Return True
    End Function

    ''' <summary>
    ''' 此函数由 EnumWindows 针对每个活动进程调用一次。
    ''' 它调用 ProcessIsActiveWindow 来验证该窗口是否为有效窗口，
    ''' 并更新该活动窗口列表框。
    ''' </summary>
    Function FillActiveWindowsList(ByVal hWnd As Integer, ByVal lParam As Integer) As Boolean
        Dim windowText As New StringBuilder(StringBufferLength)

        ' 获取窗口标题。
        Win32API.GetWindowText(hWnd, windowText, StringBufferLength)

        ' 仅将有效窗口添加到活动窗口列表框中。
        If ProcessIsActiveWindow(hWnd) Then
            lbActiveWindows.Items.Add(windowText)
        End If

        Return True
    End Function

    ''' <summary>
    ''' 此函数调用各种 Win32API 函数，以确定一个窗口进程
    ''' 是否为有效活动窗口。
    ''' </summary>
    Function ProcessIsActiveWindow(ByVal hWnd As Integer) As Boolean
        Dim windowText As New StringBuilder(StringBufferLength)
        Dim windowIsOwned As Boolean
        Dim windowStyle As Integer

        ' 获取窗口标题、所有者信息和窗口样式。
        Win32API.GetWindowText(hWnd, windowText, StringBufferLength)
        windowIsOwned = Win32API.GetWindow(hWnd, Win32API.GW_OWNER) <> 0
        windowStyle = Win32API.GetWindowLong(hWnd, Win32API.GWL_EXSTYLE)

        ' 不允许不可见进程。
        If Not Win32API.IsWindowVisible(hWnd) Then
            Return False
        End If

        ' 窗口必须具有标题
        If windowText.ToString.Equals("") Then
            Return False
        End If

        ' 不应具有父项
        If Win32API.GetParent(hWnd) <> 0 Then
            Return False
        End If

        ' 不允许使用没有所有权的工具提示
        If (windowStyle And Win32API.WS_EX_TOOLWINDOW) <> 0 And Not windowIsOwned Then
            Return False
        End If

        ' 不允许使用具有所有者的应用程序
        If (windowStyle And Win32API.WS_EX_APPWINDOW) = 0 And windowIsOwned Then
            Return False
        End If

        ' 满足所有条件的窗口即为有效活动窗口。
        Return True
    End Function

    ''' <summary>
    ''' 当 txtClassName 更改时，更新 lblFunctionCalled 标签以显示
    ''' 将调用哪个函数。
    ''' </summary>
    Private Sub txtClassName_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txtClassName.TextChanged
        ChangeFunctionCalledLabel()
    End Sub


    ''' <summary>
    ''' 当 txtWindowCaption 更改时，更新 lblFunctionCalled 标签以显示
    ''' 将调用哪个函数。
    ''' </summary>
    Private Sub txtWindowCaption_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txtWindowCaption.TextChanged
        ChangeFunctionCalledLabel()
    End Sub

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
